/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.util.properties;

import dev.toma.gunsrpg.util.properties.IPropertySerializer;
import dev.toma.gunsrpg.util.properties.PropertyRegistry;

public final class PropertyKey<V> {
    private final String key;
    private final V defaultValue;
    private final IPropertySerializer<V> serializer;

    private PropertyKey(String key, V value, IPropertySerializer<V> serializer) {
        this.key = key;
        this.defaultValue = value;
        this.serializer = serializer;
        PropertyRegistry.registerKey(this);
    }

    public static <V> PropertyKey<V> newSynchronizedKey(String key, V value, IPropertySerializer<V> serializer) {
        return new PropertyKey<V>(key, value, serializer);
    }

    public static <V> PropertyKey<V> newKey(String key, V value) {
        return PropertyKey.newSynchronizedKey(key, value, null);
    }

    public static <V> PropertyKey<V> newKey(String key) {
        return PropertyKey.newKey(key, null);
    }

    public V getDefaultValue() {
        return this.defaultValue;
    }

    public IPropertySerializer<V> getSerializer() {
        return this.serializer;
    }

    public boolean isSerializable() {
        return this.serializer != null;
    }

    public String getId() {
        return this.key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyKey that = (PropertyKey)o;
        return this.key.equals(that.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return "PropertyKey{key='" + this.key + '\'' + ", defaultValue=" + this.defaultValue + '}';
    }
}

